#!/usr/bin/python3
# ==============================================================================================
# Stream design            
# Runs until end of stream or killed                        
# ==============================================================================================
class Stream:
    """RTTY_Stream.Stream Class: Process a sound stream"""
    def __init__(self,dbg=False):
        self._dbg     = dbg
        self._opened  = False
        self._running = False
        self._exists  = False
        self.player="omxplayer"
        self.pid=None
        self.p  =0
    # ------------------------------------------------------------------------------------------
    def __repr__(self):
        return "player:'{}'".format(self.player)
    # ------------------------------------------------------------------------------------------
    @property
    def dbg(self):
        return self._dbg
    @dbg.setter
    def dbg(self,x):
        self._dbg=x
    # ------------------------------------------------------------------------------------------
    @property
    def opened(self):
        return self._opened
    # ------------------------------------------------------------------------------------------
    @property
    def running(self):
        return self._running
    # ------------------------------------------------------------------------------------------
    @property
    def exists(self):
        return self._exists
   # ------------------------------------------------------------------------------------------
    @property
    def player(self):
        return self._player
    @player.setter
    def player(self,x):
        import os, sys
        self._exists=True
        try:
            res=os.system(x + " -v >/dev/null 2>&1")
        except Exception as e:
            self._player=""
            self._exists=False
            sys.tracebacklimit = None            
            raise ValueError("Stream player '"+x+"' not found")
        self._player=x
        if (res!=0):
            self._player=""
            self._exists=False
            sys.tracebacklimit = None
            raise ValueError("Stream player '"+x+"' not found")
    # ------------------------------------------------------------------------------------------        
    def Open(self):
        self._opened=True
        return
    # ------------------------------------------------------------------------------------------        
    def Close(self):
        self._opened=False
        return
    # ------------------------------------------------------------------------------------------        
    def Play(self,name):        
        import os
        import subprocess
        if (self._opened):
            try:
                devnull=open('/dev/null', 'w')
                self._running=True
                self.p=subprocess.Popen([self._player,name],preexec_fn=os.setsid,stdout=devnull, shell=False)
                self.pid=self.p.pid
                if (self._dbg): print("INFO:  STREAM PROCESS STARTED")
                self.Wait()
                self._running=False
                if (self._dbg): print("INFO:  STREAM PROCESS ENDED")
            except Exception as e:
                self._running=False
                if (self._dbg): print("ERROR: STREAM PROCESS NOT STARRED ({0})".format(e))
                pass
    # ------------------------------------------------------------------------------------------        
    def Abort(self):            # Process to be killed has been detached from console (os.setsid)
        import signal, os       # To avoid killing father process
        if (self._running):
            self._running=False
            try:
                os.killpg(os.getpgid(self.pid), signal.SIGTERM)
                self.Wait()
                if (self._dbg): print("INFO:  STREAM PROCESS KILLED")
            except Exception as e:
                if (self._dbg): print("ERROR: STREAM PROCESS NOT KILLED ({0})".format(e))
                pass
    # ------------------------------------------------------------------------------------------        
    def KillConsole(self):      # Killing from direct console launch
        import os
        if (self._running):
            os.killpg(os.getpgid(self.pid), signal.SIGTERM)
            os.system('stty sane')
    # ------------------------------------------------------------------------------------------        
    def Wait(self):        
        self.p.wait()
    # ------------------------------------------------------------------------------------------
    def Test(self):
        print("TEST:  STREAM PLAYER")
        try:
            self.Open()
            self.Play("http://www.michaelborthwick.com.au/pi1.mp4")
            self.Close()
        except:
            print("-> Not passed")
            pass
# ==============================================================================================
if __name__ == '__main__':
    import sys
    import signal
    from inspect import getdoc
    def signal_term_handler(signal, frame):
        this.KillConsole()
        sys.exit(0)
    signal.signal(signal.SIGINT,  signal_term_handler)
    signal.signal(signal.SIGTERM, signal_term_handler)
    print(getdoc(Stream))
    this=Stream()
    this.dbg=True
    this.Test()
# =============================================================================================
