#!/usr/bin/python3
# =============================================================================================
# Web design 
# ==============================================================================================
class Server:
    """RTTY_Server.Server Class: Wrapper to handle the web server"""
    # ------------------------------------------------------------------------------------------
    def __init__(self,path="../web/",dbg=False):
        self._dbg = dbg
        self._running = False
        self._exists = True
        self.path = path
        self.player = "server.py"
        self.pid = None
        self.p  = 0
    # ------------------------------------------------------------------------------------------
    def __repr__(self):
        return "player:'{}' path:'{}'".format(self.player, self._path)
    # ------------------------------------------------------------------------------------------
    @property
    def dbg(self):
        return self._dbg
    @dbg.setter
    def dbg(self, x):
        self._dbg = x
    # ------------------------------------------------------------------------------------------
    @property
    def running(self):
        return self._running
    # ------------------------------------------------------------------------------------------
    @property
    def exists(self):
        return self._exists
    # ------------------------------------------------------------------------------------------
    @property
    def path(self):
        return self._path
    @path.setter
    def path(self, x):
        import os, sys
        self._exists = True
        if (os.path.exists(x)):
            self._path = x+"/"
        else:
            self._path = ""
            self._exists = False
            sys.tracebacklimit = None
            raise ValueError("Web server path '"+x+"' not found")
    # ------------------------------------------------------------------------------------------
    @property
    def player(self):
        return self._player
    @player.setter
    def player(self, x):
        import os,sys
        if (os.path.exists(self._path+x)):
            self._exists = True
            self._player = x
        else:
            self._player = ""
            self._exists = False
            sys.tracebacklimit = None
            raise ValueError("Web server '"+self._path+x+"' not found")
    # -------------------------------------------------------------------------------------------        
    def Run(self):
        import os
        if (self._exists):
            try:
                import os, subprocess
                self._running = True
                devnull = open('/dev/null', 'w')
                self.p = subprocess.Popen([self._path+self._player],preexec_fn=os.setsid, stdout=devnull, shell=False)
                self.pid = self.p.pid
                if (self._dbg): print("INFO:  WEB SERVER PROCESS STARTED")
                self.Wait()
                self._running = False
                if (self._dbg): print("INFO:  WEB SERVER PROCESS ENDED")
            except Exception as e:
                self._running = False
                if (self._dbg): print("ERROR: WEB SERVER PROCESS NOT STARTED ({0})".format(e))
                pass
    # ------------------------------------------------------------------------------------------        
    def Abort(self):            # Process to be killed has been detached from console (os.setsid)
        import signal, os       # To avoid killing father process
        if (self._running):
            self._running = False
            try:
                os.killpg(os.getpgid(self.pid), signal.SIGTERM)
                self.Wait()
                if (self._dbg): print("INFO:  WEB SERVER PROCESS KILLED")
            except Exception as e:
                if (self._dbg): print("ERROR: WEB SERVER PROCESS NOT KILLED ({0})".format(e))
                pass
    # ------------------------------------------------------------------------------------------        
    def KillConsole(self):      # Killing from direct console launch
        import os
        if (self._running):
            os.killpg(os.getpgid(self.pid), signal.SIGTERM)
            os.system('stty sane')
    # ------------------------------------------------------------------------------------------
    def Wait(self): 
        self.p.wait()
    # ------------------------------------------------------------------------------------------
    def Test(self):
        print("TEST:  WEB SERVER")
        try:
            self.Run() 
        except:
            print("-> Not passed")
            pass
# ==============================================================================================
if __name__ == '__main__':
    import sys
    import signal
    from inspect import getdoc
    def signal_term_handler(signal, frame):
        this.KillConsole()
        sys.exit(0)
    signal.signal(signal.SIGINT,  signal_term_handler)
    signal.signal(signal.SIGTERM, signal_term_handler)
    print(getdoc(Server))
    this =Server()
    this.dbg = True
    this.Test()
# ==============================================================================================
