#!/usr/bin/python3 -u
# ----------------------------------------------------------------------------------------------
# TODO
# Reverse Item from oldest to newest sorting on date
# Process CTRL^C and ssty sane
# Process killing before running the mode thread
# Modes are selected as follow:
#       Serial connected        Serial not connected
#   0   mode_slnk  Web Data     mode_dfsk   Web Data
#   1   mode_wlnk  Web Term     mode_sfsk   Ext Stream               
# ----------------------------------------------------------------------------------------------
import sys
import signal
from threading import Thread, Lock
sys.path.insert(0, './src')
import RTTY_Serial
import RTTY_ITA2
import RTTY_FSK
import RTTY_Audio
import RTTY_Stream
import RTTY_WebPage
import RTTY_Hash
import RTTY_Server
try:
    import RPi.GPIO as rpiGPIO
except:
    pass
# ----------------------------------------------------------------------------------------------
g_tst = False
g_dbg = False
g_nrp = False
m_iop = Lock()
m_run = Lock()
m_abt = False
# ==============================================================================================
# CTRL-C Handling
# ==============================================================================================
def signal_term_handler(signal, frame):
    mode_sfsk_abort()
    mode_dfsk_abort()
    mode_slnk_abort()
    mode_wlnk_abort()
    print()
    print("Exit")
    print()
    sys.exit(0)
# ==============================================================================================
# IO Process
# ==============================================================================================
def IO_halt_evt(pinnum):
    print("INFO:  SHUTDOWN NOW")
    if (g_dbg): return
    IO_unregister_events()
    snd = RTTY_Audio.Audio()     
    snd.Play("Shutdown.wav")
    time.sleep(1)
    os.system("sync;sync;halt")
    while 1:
        time.sleep(1)
# ----------------------------------------------------------------------------------------------
def IO_mode_evt(pinnum):
    global m_iop
    m_iop.acquire()
    IO_unregister_events()
    if (not g_tst): print("INFO:  MODE CHANGE CALL ("+str(pinnum)+")")
    mode_sfsk_abort()
    mode_dfsk_abort()
    mode_slnk_abort()
    mode_wlnk_abort()
    time.sleep(0.25)                                            # Wait for other events gone
    IO_register_events()
    if (not g_tst): print("INFO:  MODE CHANGE END  ("+str(pinnum)+")")
    m_iop.release()
# ----------------------------------------------------------------------------------------------
def IO_mode_sts():
    if (not g_tst): print("INFO:  MODE READ STATE")
    if (g_dbg): return False
    if (g_nrp): return False
    rpiGPIO.setmode(rpiGPIO.BCM)
#(A)state = rpiGPIO.input(MODE2) << 1 | rpiGPIO.input(MODE1)
    state = rpiGPIO.input(MODE1)
    if (not g_tst): print("INFO:  MODE READ STATE ("+str(state)+")")
    return state
# ----------------------------------------------------------------------------------------------
def IO_link_sts(sound):
    if (not g_tst): print("INFO:  LINKS READ STATE")
    if (g_dbg): return False
    if (g_nrp): return False
    rpiGPIO.setmode(rpiGPIO.BCM)
    rpiGPIO.setup(LINKS, rpiGPIO.IN, pull_up_down=rpiGPIO.PUD_UP)
    state = rpiGPIO.input(LINKS)
    if (sound):
        snd = RTTY_Audio.Audio()
        if (state==0):
            snd.Play("SerialMode.wav")
        else:
            snd.Play("AudioMode.wav")
    if (not g_tst): print("INFO:  LINKS READ STATE ("+str(state)+")")
    return state
# ==============================================================================================
# IO register
# ----------------------------------------------------------------------------------------------
LINKS = 24      # Serial connected / not connected
MODE1 = 22      # Mode selector
MODE2 = 23      # Mode selector extension (no mode used) see(A)
# ----------------------------------------------------------------------------------------------
#(A)EventsTable = {17:IO_halt_evt, MODE1:IO_mode_evt, MODE2:IO_mode_evt}
EventsTable = {17:IO_halt_evt, MODE1:IO_mode_evt}
# ----------------------------------------------------------------------------------------------
def IO_register_event(pinnum):
    if (g_dbg): return
    if (g_nrp): return
    rpiGPIO.setup(pinnum, rpiGPIO.IN, pull_up_down=rpiGPIO.PUD_UP)
    rpiGPIO.add_event_detect(pinnum, rpiGPIO.BOTH, callback=EventsTable[pinnum], bouncetime=250)
# ----------------------------------------------------------------------------------------------
def IO_unregister_events():
    if (g_dbg): return
    if (g_nrp): return
    for event in EventsTable:
        rpiGPIO.remove_event_detect(event)
# ----------------------------------------------------------------------------------------------
def IO_register_events():
    if (g_dbg): return
    rpiGPIO.setmode(rpiGPIO.BCM)                  # Broadcom GPIO numbers
    for event in EventsTable:
        IO_register_event(event)
# ==============================================================================================
# Config
# ----------------------------------------------------------------------------------------------
def getConf():
    import configparser
    parser = configparser.ConfigParser()
    # -----------------------------------------------------------------------------------------
    import os,sys
    from pathlib import Path
    pth=os.path.abspath(os.path.dirname(sys.argv[0]))
    if (os.path.basename(pth)=="src"): 
        pth = str(Path(pth).parent)
    pth=pth+"/web"
    sit = 0
    url = "http://209.180.212.65:8000"
    # -----------------------------------------------------------------------------------------
    try:
        parser.read('./config.ini')
    except:       
        pass
    # -----------------------------------------------------------------------------------------
    try:
        sit = int(parser.get('Site_Index', 'index'))
        if (sit < 0) or (sit > 3):
            sit = 0
    except:
        pass
    # -----------------------------------------------------------------------------------------
    try:
        url = (parser.get('Site_AFSK', 'url'))
    except:
        pass
   # -----------------------------------------------------------------------------------------
    print("INFO:  WEB  " +       pth)
    print("INFO:  Feed N." + str(sit))
    print("INFO:  AFSK " +       url)
    return pth,url,sit
# ==============================================================================================
# Audio stream mode processing
# ----------------------------------------------------------------------------------------------
h_str=[None,None]
m_str=[Lock(),Lock()]
# ----------------------------------------------------------------------------------------------
def mode_sfsk_abort():
    global h_str, m_str, m_abt
    m_abt=True
    if (g_dbg): print("SFSK ABORT START")
    for i,k in enumerate(m_str):
        if (not k.acquire(False)):  
            if (g_dbg): print("ABORT Task "+str(i))
            if (h_str[i] is not None): h_str[i].Abort()
        else:   k.release()
    if (g_dbg): print("SFSK ABORT END")
# ----------------------------------------------------------------------------------------------
def mode_sfsk(url):
    global h_str, m_str, m_run
    m_run.acquire()
    # ------------------------------------------------------------------------------------------
    if (h_str[1] is not None):
        raise ValueError("PANIC: Audio  device already opened")
        m_run.release()
    # ------------------------------------------------------------------------------------------
    print("INFO:  SFSK START")
    # ------------------------------------------------------------------------------------------
    # Get a sound
    # ------------------------------------------------------------------------------------------
    m_str[0].acquire()
    h_str[0] = RTTY_Audio.Audio()
    h_str[0].Play("SFSKMode.wav")                 # Stream FSK
    m_str[0].release()
    # ------------------------------------------------------------------------------------------
    if (m_abt):
        m_run.release()
        return
    # ------------------------------------------------------------------------------------------
    # Get an output
    # ------------------------------------------------------------------------------------------
    m_str[1].acquire()
    h_str[1] = RTTY_Stream.Stream()
    h_str[1].Open()
    if (g_dbg): h_str[1].dbg = True
    h_str[1].Play(url)
    h_str[1].Close()
    m_str[1].release()
    # ------------------------------------------------------------------------------------------
    h_str=[None,None]
    # ------------------------------------------------------------------------------------------
    print("INFO:  SFSK MODE ENDS")
    m_run.release()
# ==============================================================================================
# FSK Data mode processing
# ----------------------------------------------------------------------------------------------
h_fsk=[None,None,None]
m_fsk=[Lock(),Lock(),Lock()]
# ----------------------------------------------------------------------------------------------
def mode_dfsk_abort():
    global h_fsk, m_fsk, m_abt
    m_abt=True
    if (g_dbg): print("DFSK ABORT START")
    for i,k in enumerate(m_fsk):
        if (not k.acquire(False)):  
            if (g_dbg): print("ABORT Task "+str(i))
            if (h_fsk[i] is not None): h_fsk[i].Abort()
        else:   k.release() 
    if (g_dbg): print("DFSK ABORT END")
# ----------------------------------------------------------------------------------------------
def mode_dfsk(idx):
    global h_fsk
    global m_fsk
    global m_run
    m_run.acquire()
    if (h_fsk[1] is not None):
        raise ValueError("PANIC: FSK device already opened")
        m_run.release()
    # ------------------------------------------------------------------------------------------
    print("INFO:  DFSK  MODE START")
    # ------------------------------------------------------------------------------------------
    # Get a sound
    # ------------------------------------------------------------------------------------------
    m_fsk[0].acquire()
    h_fsk[0] = RTTY_Audio.Audio()
    h_fsk[0].Play("DFSKMode.wav")                 # Data FSK
    m_fsk[0].release()
    # ------------------------------------------------------------------------------------------
    if (m_abt):
        m_run.release()
        return
    # ------------------------------------------------------------------------------------------
    # Get a printer
    # ------------------------------------------------------------------------------------------
    m_fsk[1].acquire()
    h_fsk[1] = RTTY_FSK.Fsk()
    h_fsk[1].Open()
    if (g_dbg): h_fsk[1].dbg = True
    # ------------------------------------------------------------------------------------------
    # Gets a converter
    # ------------------------------------------------------------------------------------------
    ita = RTTY_ITA2.Ita2()
    ita.table = 1
    # ------------------------------------------------------------------------------------------
    # Read page and get new items until process is killed
    # ------------------------------------------------------------------------------------------
    m_fsk[2].acquire()
    h_fsk[2]= RTTY_WebPage.WebPage()
    h_fsk[2].site = idx
    while(h_fsk[1].opened):
        # ------------------------------------------------------------------------------------------
        text = h_fsk[2].Read()
        # ------------------------------------------------------------------------------------------
        if (text != ""):
            if (h_fsk[1].ita2extern): text = ita.toIta2(text)
            h_fsk[1].Print(text)
        # ------------------------------------------------------------------------------------------
        if (not h_fsk[1].running): break
    # ------------------------------------------------------------------------------------------
    h_fsk[1].Wait()
    h_fsk[1].Close()
    m_fsk[1].release()
    m_fsk[2].release()
    time.sleep(1)
    # ------------------------------------------------------------------------------------------
    h_fsk=[None,None,None]
    # ------------------------------------------------------------------------------------------
    print("INFO:  DFSK MODE ENDS")
    m_run.release()
# ==============================================================================================
# Serial Data mode processing
# ----------------------------------------------------------------------------------------------
h_ser=[None,None,None]
m_ser=[Lock(),Lock(),Lock()]
# ----------------------------------------------------------------------------------------------
def mode_slnk_abort():
    global h_ser, m_ser, m_abt
    m_abt=True
    if (g_dbg): print("SLNK ABORT START")
    for i,k in enumerate(m_ser):
        if (not k.acquire(False)):
            if (g_dbg): print("ABORT Task "+str(i))
            if (h_ser[i] is not None): h_ser[i].Abort()
        else:   
            k.release()
    if (g_dbg): print("SLNK ABORT END")
# ----------------------------------------------------------------------------------------------
def mode_slnk(idx):
    global h_ser, m_ser, m_run
    m_run.acquire()
    if (h_ser[1] is not None):
        raise ValueError("PANIC: Serial device already opened")
        m_run.release()
    # ------------------------------------------------------------------------------------------
    print("INFO:  SLNK  MODE START")    
    # ------------------------------------------------------------------------------------------
    # Get a sound
    # ------------------------------------------------------------------------------------------
    m_ser[0].acquire()
    h_ser[0] = RTTY_Audio.Audio()
    h_ser[0].Play("SLNKMode.wav")            
    m_ser[0].release()
    # ------------------------------------------------------------------------------------------
    if (m_abt):
        m_run.release()
        return
    # ------------------------------------------------------------------------------------------
    # Get a printer
    # ------------------------------------------------------------------------------------------
    m_ser[1].acquire()
    h_ser[1] = RTTY_Serial.Serial()
    h_ser[1].Open()
    if (g_dbg): h_ser[1].dbg = True
    # ------------------------------------------------------------------------------------------
    # Gets a converter
    # ------------------------------------------------------------------------------------------
    ita = RTTY_ITA2.Ita2()
    ita.table = 1
    # ------------------------------------------------------------------------------------------
    # Read page and get new items until process is killed
    # ------------------------------------------------------------------------------------------
    m_ser[2].acquire()
    h_ser[2] = RTTY_WebPage.WebPage()
    h_ser[2].site = idx
    while(h_ser[1].opened):
        # ------------------------------------------------------------------------------------------
        text = h_ser[2].Read()
        # ------------------------------------------------------------------------------------------
        if (text != ""):
            h_ser[1].Print(ita.null())
            h_ser[1].Print(ita.toIta2(text))
        # ------------------------------------------------------------------------------------------
        if (not h_ser[1].running): break
    # ------------------------------------------------------------------------------------------
    h_ser[1].Wait()
    h_ser[1].Close()
    m_ser[2].release()
    m_ser[1].release()
    time.sleep(1)
    # ------------------------------------------------------------------------------------------
    h_ser=[None,None,None]
    # ------------------------------------------------------------------------------------------
    print("INFO:  SLNK MODE ENDS")
    m_run.release()
# ==============================================================================================
# Web server serial mode processing
# ----------------------------------------------------------------------------------------------
h_web=[None,None]
m_web=[Lock(),Lock()]
# ----------------------------------------------------------------------------------------------
def mode_wlnk_abort():
    global h_web,m_web, m_abt
    m_abt=True
    if (g_dbg): print("WLNK ABORT START")
    for i,k in enumerate(m_web):
        if (not k.acquire(False)):  
            if (g_dbg): print("ABORT Task "+str(i))
            if (h_web[i] is not None): h_web[i].Abort()
        else:   k.release()
    if (g_dbg): print("WLNK ABORT END")
# ----------------------------------------------------------------------------------------------
def mode_wlnk(pth):
    global h_web, m_web, m_run
    m_run.acquire()
    # ------------------------------------------------------------------------------------------
    if (h_web[1] is not None):
        raise ValueError("PANIC: Web server already running")
        m_run.release()
    # ------------------------------------------------------------------------------------------
    print("INFO:  WLNK START")
    # ------------------------------------------------------------------------------------------
    # Get a sound
    # ------------------------------------------------------------------------------------------
    m_web[0].acquire()
    h_web[0] = RTTY_Audio.Audio()
    h_web[0].Play("WLNKMode.wav")                 # Stream FSK
    m_web[0].release()
    # ------------------------------------------------------------------------------------------
    if (m_abt):
        m_run.release()
        return
    # ------------------------------------------------------------------------------------------
    # Get an output
    # ------------------------------------------------------------------------------------------
    m_web[1].acquire()
    h_web[1] = RTTY_Server.Server(pth)
    if (g_dbg): h_web[1].dbg = True
    h_web[1].Run()
    m_web[1].release()
    # ------------------------------------------------------------------------------------------
    h_web=[None,None]
    # ------------------------------------------------------------------------------------------
    print("INFO:  WLNK MODE ENDS")
    m_run.release()
# ==============================================================================================
# Main
# ----------------------------------------------------------------------------------------------
import sys, getopt
import time
import os
from   sys import platform
# ----------------------------------------------------------------------------------------------
def main(argv):
    global g_tst, g_dbg, g_nrp, m_abt
    # ------------------------------------------------------------------------------------------
    if (not os.uname()[4].startswith("arm")):
        g_nrp = True
        print("Not running on Raspberry Pi...")
    # ------------------------------------------------------------------------------------------
    # Clean quit
    # ------------------------------------------------------------------------------------------
    signal.signal(signal.SIGINT,  signal_term_handler)
    signal.signal(signal.SIGTERM, signal_term_handler)
    # ------------------------------------------------------------------------------------------
    # g_dbg mode
    # ------------------------------------------------------------------------------------------
    try:
        opts,args = getopt.getopt(argv[1:], "td", ["testing", "debug"])
    except:
        print('service.py {-t|--testing}{-d|--debug}')
        sys.exit(2)
    # ------------------------------------------------------------------------------------------
    g_dbg = False
    g_tst = False
    for opt, arg in opts:
        if opt in ("-t", "--testing"):
            g_tst = True
        if opt in ("-d", "--debug"):
            g_dbg = True
    # ------------------------------------------------------------------------------------------
    # Get an IO processor
    # ------------------------------------------------------------------------------------------
    IO_register_events()
    # ------------------------------------------------------------------------------------------
    # Test mode
    # ------------------------------------------------------------------------------------------
    if (g_tst):
        IO_unregister_events()
        print("MODE Selector ", end='', flush=True)
        for i in range(10):
            print(IO_mode_sts(), end='', flush=True)
            time.sleep(1)
        print()
        snd = RTTY_Audio.Audio()
        snd.Test()
        fsk = RTTY_FSK.Fsk()
        fsk.Test()
        stm = RTTY_Stream.Stream()
        stm.Test()
        ser = RTTY_Serial.Serial()
        ser.Test()
        web = RTTY_WebPage.WebPage()
        web.Test()
        hsh = RTTY_Hash.Hash()
        hsh.Test()
        return
    # ------------------------------------------------------------------------------------------
    # Stand alone mode
    # ------------------------------------------------------------------------------------------
    # Get conf
    # ------------------------------------------------------------------------------------------
    pth, url, sit = getConf()
    # ------------------------------------------------------------------------------------------
    # Inform us
    # ------------------------------------------------------------------------------------------
    snd = RTTY_Audio.Audio()
    snd.Play("RaspberryTTY.wav")
    # ------------------------------------------------------------------------------------------
    IO_link_sts(True)
    # ------------------------------------------------------------------------------------------
    # Will loop forever starting from there
    #       Serial connected        Serial not connected
    #   0   mode_slnk  Web Data     mode_dfsk   Web Data
    #   1   void                    mode_sfsk   Ext Stream               
    # ------------------------------------------------------------------------------------------
    while True:
        print("INFO:  GET  NEW MODE")
#       while (m_iop.locked() or m_run.locked()): time.sleep(0.100)
        m_iop.acquire(True)                     # Wait for mode change finished
        m_iop.release()
        m_run.acquire(True)                     # Wait for run finished
        m_run.release()
        m_abt=False
        a = IO_mode_sts()
        print("INFO:  GET  MODE "+str(a))
        if (IO_link_sts(False)==0):             # Serial
            if   (0 == a): mode_wlnk(pth)       #  Will loop forever starting from there
            else:          mode_slnk(sit)       #  Will loop forever starting from there
        else:                                   # Audio            
            if   (0 == a): mode_dfsk(sit)       #  Will loop forever starting from there
            else:          mode_sfsk(url)       #  Will loop forever starting from there
    # ------------------------------------------------------------------------------------------    
# ==============================================================================================
#
# ==============================================================================================
if __name__ == "__main__":
    import os
    main(sys.argv)
# ----------------------------------------------------------------------------------------------
