#!/usr/bin/python3 -u
import sys, getopt
import tty, termios
import select
sys.path.insert(0, './lib')
import RTTY_Serial
import RTTY_ITA2
import RTTY_Print
# ==============================================================================================
def usage(argv):
    print(argv[0]+" {-u|--us}{-f|--fr}")
    print(" -u  US ITA2 Table")
    print(" -f  FR ITA2 Table")
    sys.exit(2)
# ----------------------------------------------------------------------------------------------
def main(argv):
    # ------------------------------------------------------------------------------------------
    try:
        opts,args = getopt.getopt(argv[1:], "ufh", ["us", "fr", "help"])
    except:
        usage(argv)
        sys.exit(2)
    # ------------------------------------------------------------------------------------------
    tbl = 0
    tbm = ["US", "FR"]
    for opt,arg in opts:
        if opt in ("-h", "--help"):
            usage(argv)
            sys.exit(2)
        if opt in ("-u", "--us"): tbl = 0
        if opt in ("-f", "--fr"): tbl = 1
    # ------------------------------------------------------------------------------------------
    print("ITA2 characters reader")
    print(" Using "+tbm[tbl]+" table")
    print("Hit any key to exit...")
    # ------------------------------------------------------------------------------------------
    # Set TTY to non blocking character read
    # ------------------------------------------------------------------------------------------
    fd = sys.stdin.fileno()
    st = termios.tcgetattr(fd)
    tty.setraw(fd)
    # ------------------------------------------------------------------------------------------
    # Get an ITA2 converter, a serial link and a colour ouput
    # ------------------------------------------------------------------------------------------
    ita = RTTY_ITA2.Ita2()
    ita.table = tbl
    # ------------------------------------------------------------------------------------------
    ser = RTTY_Serial.Serial()
#   ita.dbg = True
#   ser.dbg = True
    ser.timeout = None
    # ------------------------------------------------------------------------------------------
    col = RTTY_Print.Print()
    # ------------------------------------------------------------------------------------------
    ser.Open()
    while(True):
        # --------------------------------------------------------------------------------------
        # Keyboard character pressed
        # --------------------------------------------------------------------------------------
        if (select.select([sys.stdin], [], [],0) == ([sys.stdin], [], [])):
            c = sys.stdin.read(1)
            if (c):
                termios.tcsetattr(fd, termios.TCSADRAIN, st)
                ser.Close()
                print("Exit")
                print()
                sys.exit(1)
        # --------------------------------------------------------------------------------------
        # Serial character receiver
        # --------------------------------------------------------------------------------------
        if (ser.in_waiting != 0):
            dat = ser.Read(ser.in_waiting)
            if (dat):
                msg = ita.toAscii(dat)
                col.print(msg.upper(), col.RED)
        # --------------------------------------------------------------------------------------
# ==============================================================================================
if __name__ == '__main__':
    main(sys.argv)
# ==============================================================================================
